#include <Wt/WMenu> //WMenu
#include <Wt/WLabel> //WLabel
#include <Wt/WStackedWidget> //WStackedWidget

#include "StoreManageTabWidget.h" //StoreManageTabWidget

/*!
 * \brief StoreManageTabWidget::StoreManageTabWidget Constructor.
 * \param Ssn2Use The wt dbo session to use.
 */
StoreManageTabWidget::StoreManageTabWidget(Dbo::Session *Ssn2Use):session(Ssn2Use)
{
    qDebug() << __FILE__ << __LINE__ << __func__ << QObject::tr("constructor"); //Debug.
  
    //设置本身的CSS样式类：
    setStyleClass("FileManageTabWidget"); //设置样式类。

    //左侧的菜单及底部区域：
    WContainerWidget * LeftArea=new WContainerWidget; //创建部件。
    LeftArea->setStyleClass("LeftArea"); //左侧区域。
    addWidget(LeftArea); //添加到界面中。

    //左侧背景：
    WLabel * LeftBgLbl=new WLabel(LeftArea); //左侧背景。
    LeftBgLbl->setStyleClass("LeftBgLbl"); //左侧背景。

    //右侧的操作区域：

    WContainerWidget * RightFileArea=new WContainerWidget; //创建容器。
    RightFileArea->setStyleClass("RightFileArea"); //样式类。
    addWidget(RightFileArea); //添加到界面中。

    //添加一个栈式部件到右侧操作区域中：
    RtStk=new WStackedWidget; //创建栈式部件。
    RightFileArea->addWidget(RtStk); //添加到右侧容器中。

    //添加各个子页面：
    //财务资金流水列表：
    StorLstWdgt=new ArticleListWidget(session); //创建Store列表部件。
    RtStk->addWidget(StorLstWdgt); //添加到栈中。
} //FileManageTabWidget::FileManageTabWidget()

/*!
 * \brief FileManageTabWidget::~FileManageTabWidget Destructor.
 */
StoreManageTabWidget::~StoreManageTabWidget()
{
    delete StorLstWdgt; //delete user verification tab.
} //FileManageTabWidget::~FileManageTabWidget() //!<Destructor.

/*!
 * \brief StoreManageTabWidget::GotoStoreList Saved store,then goto store list.
 */
void StoreManageTabWidget::GotoStoreList()
{
    StorLstWdgt->refresh (); //Refresh the store list.

    return;
} //void StoreManageTabWidget::GotoStoreList() //!<Saved store,then goto store list.

/*!
 * \brief StoreManageTabWidget::SetRestrictedInfoAccess Set the info access previlege.
 * \param WhetherRestricttrue Whether we should restrict the access of this user in the current session.
 * \param RstctUsrId The user id bound to this session.
 */
void StoreManageTabWidget::SetRestrictedInfoAccess(bool WhetherRestricttrue,int RstctUsrId)
{
    StorLstWdgt->SetRestrictedInfoAccess(WhetherRestricttrue,RstctUsrId); //Set this restrict to the store list.

    return;
} //void StoreManageTabWidget::SetRestrictedInfoAccess(bool WhetherRestricttrue,int RstctUsrId) //!<Set the info access previlege.
