#include "SBlogPreCompile.h" //WImage

#include "ArticleDigestWidget.h" //ArticleDigestWidget
#include "SbDbItem.h" //SbDbItem

/*!
 * \brief ActiveTicketListWidget::ActiveTicketListWidget Constructor.
 * \param Ssn2Use The wt dbo session to use.
 */
ArticleDigestWidget::ArticleDigestWidget()
{
    UsrId=0; //Default,no valid user id.

    WrnngLbl=new WLabel(WString::tr("Warning:this page is more of debugging purpose,think twice before you delete any ticket on this page.")); //警告文字。
    WrnngLbl->setStyleClass ("digestArticleTitle"); //Set the style class.

    ttlCntr=new WContainerWidget; //Create the title container.
    addWidget (ttlCntr); //Show the title container.
    ttlCntr->addWidget(WrnngLbl); //显示Title。


    SlshLbl=new WLabel(WString::tr("/")); //The slash.
    addWidget(SlshLbl); //Add the slash.


    PgSpnBx=new WLabel; //Create the page number spin box.
    addWidget(PgSpnBx); //Show the spin box.

    ctgrLbl=new WLabel; //Create the category label.
    addWidget (ctgrLbl); //Show the category label.

    lvCmtLbl=new WLabel; //Create the leave comment label.
    lvCmtLbl->setText (WString::tr(" |Leave a comment")); //Set the text.
    addWidget(lvCmtLbl); //Add the leave comment label.

    WContainerWidget * thmDgstCntCntr=new WContainerWidget; //Create the thumb digest continue reading container.
    addWidget (thmDgstCntCntr); //Add the container.

    thmImg=new WImage; //Create the thumb image.
    thmDgstCntCntr->addWidget (thmImg); //Add the thumb image.

    digestLbl=new WLabel; //Create the digest label.
    digestLbl->setStyleClass ("digestLabel"); //设置样式类，摘要文字标签。
    thmDgstCntCntr->addWidget (digestLbl); //Add the digest label.

    contRdingBtn=new WPushButton(WString::tr("Continue reading ...")); //创建按钮，继续阅读。
    contRdingBtn->setStyleClass ("continueReadingBtn"); //设置样式类，继续阅读按钮。
    thmDgstCntCntr->addWidget (contRdingBtn); //添加继续阅读按钮。
} //ArticleDigestWidget::ArticleDigestWidget()

/*!
 * \brief StoreListWidget::EditStore  Edit this store.
 * \param ImgPtrid The store id.
 */
void ArticleDigestWidget::EditStore(int ImgPtrid)
{
    ShouldEditStore.emit(ImgPtrid); //Emit the signal.

    return;
} //void StoreListWidget::EditStore(int ImgPtrid) //!<Edit this store.

/*!
 * \brief ArticleDigestWidget::setArticleId 设置文章的编号。
 * \param atclId 要设置的文章编号。
 */
void ArticleDigestWidget::setArticleId(int atclId)
{
    dbo::Transaction transaction(*session); //创建事务。

    dbo::ptr<SbDbItem> atclObj=session->find<SbDbItem>().where("id=?").bind(atclId); //按照编号来查询文章。

    dbo::collection<dbo::ptr<SbDbComment> > cmtLst=atclObj->commentList; //获取评论列表。
    dbo::collection<dbo::ptr<SbDbComment> > blnkCmtLst=dbo::collection<dbo::ptr<SbDbComment> >(); //空白 的评论列表。
    dbo::collection<dbo::ptr<SbDbCategory> > blnkCtgrLst=dbo::collection<dbo::ptr<SbDbCategory> >(); //空白的分类列表。
    dbo::ptr<SbDbAuthor> ahrObj=atclObj->author; //获取作者对象。
    dbo::ptr<SbDbAuthor> blnkAhr=dbo::ptr<SbDbAuthor> (); //空白作者对象。
    dbo::collection<dbo::ptr<SbDbTag> > blnkTagLst=dbo::collection<dbo::ptr<SbDbTag> >(); //空白的标记列表。

    transaction.commit (); //提交事务。

    return;
} //void ArticleDigestWidget::setArticleId(int atclId)
