#ifndef ARTICLE_DIGEST_WIDGET_H
#define ARTICLE_DIGEST_WIDGET_H

#include <Wt/Dbo/backend/Sqlite3> //Sqlite3
#include <Wt/Dbo/Session> //Session
#include <Wt/WContainerWidget> //WContainerWidget
#include <qrencode.h> //QRcode

namespace dbo=Wt::Dbo; //dbo命名空间别名。
using namespace Wt; //WContainerWidget

#include "SbDbItem.h" //SbDbItem

/*!
 * \brief The ArticleDigestWidget class Represents an article digest.
 */
class ArticleDigestWidget : public WContainerWidget
{
public:
    void setArticleId(int atclId); //!<设置文章的编号。
    ArticleDigestWidget(); //!<Constructor.
    Signal  <int>  ShouldEditStore; //!<Should edit the store of this id.

private:
    dbo::Session * session; //!<数据库会话。
    WPushButton * contRdingBtn; //!<继续阅读按钮。
    WLabel * digestLbl; //!<The digest label.
    WImage * thmImg; //!<The thumb image.
    WLabel * lvCmtLbl; //!<The leave a comment label.
    WLabel * ctgrLbl; //!<The category label.
    WContainerWidget * ttlCntr; //!<The title container.
    WLabel * SlshLbl; //!<The written time label.
    WLabel * WrnngLbl; //!<The article title label.
    void EditStore(int ImgPtrid); //!<Edit this store.
    int UsrId; //!<The user id.
    WLabel * PgSpnBx; //!<The author label.
}; //class ArticleDigestWidget : public WContainerWidget

#endif // FINANCEFLOWLISTWIDGET_H
