
#include <Wt/WOverlayLoadingIndicator> //WOverlayLoadingIndicator
#include <Wt/WImage> //WImage
#include <QtDebug> //qDebug

#include "QueueMateWebApplication.h" //QueueMateWebApplication

/*!
  *@brief 构造函数。
  *
  *WQApplication构造函数中第二个参数是指启用QT事件循环。
  */
QueueMateWebApplication::QueueMateWebApplication(const WEnvironment& env): WApplication(env)
{
    messageResourceBundle().use("Translations/zh_cn"); //载入翻译内容，使用简体中文。


    WebPage= new SBlog(root()); //创建一个网站对象。
    WebPage->SetApp(this); //设置应用程序实例。

    WString CrtTmStr=WDateTime::currentDateTime().toString("hhmmss"); //当前时间对应的字符串。

    useStyleSheet("QueueMateWeb.css?version="+CrtTmStr.toUTF8()); //设置样式单。


    enableUpdates (true); //启用服务器推。


} //GenieProWebApplication::GenieProWebApplication(const WEnvironment& env)
//: WApplication(env)


/*!
  *@brief 析构函数。
  */
QueueMateWebApplication::~QueueMateWebApplication()
{
    delete WebPage; //删除对象。
} //GenieProWebApplication::~GenieProWebApplication()

/*!
 * \brief P2pWebApplication::GetWebPage 获取网页对象。
 * \return 网页对象。
 */
SBlog * QueueMateWebApplication::GetWebPage()
{
    return WebPage;
} //P2pWeb * P2pWebApplication::GetWebPage() //!<获取网页对象。
