#ifndef SBLOG_H
#define SBLOG_H

#include "SBlogPreCompile.h" //Postgres

#include "StoreManageTabWidget.h" //StoreManageTabWidget

using namespace Wt; //使用Wt命名空间。

/*!
  *@brief 这表示整个网站程序。
  */
class SBlog : public WContainerWidget
{
public:
    void SetApp(WApplication * this2St); //!<设置应用程序实例。
    SBlog(WContainerWidget *Parent); //!<构造函数，指定亲代部件。
    ~SBlog(); //!<析构函数。


protected :
    void refresh(); //!<刷新事件。

private:
    void setupUi(); //!<setup the ui.
    dbo::backend::Postgres sqlite3; //!<数据库。
    dbo::Session session; //!<会话。
    WApplication * app; //!<应用程序实例。
    StoreManageTabWidget * StorMngTab; //!<文件管理标签页。
    void GotoFileManage(); //!<跳转到文件管理页面。
    void ShowCfg(); //!<显示配置文件。
    void SyncCfg(); //!<从“管理”系统将配置信息同步过来。
    void ModifyPassword(); //!<修改密码。
    void SetPathRoot(); //!<设置内部路径为根路径。
    WTabWidget * Tabs; //!<用来管理那些标签页的标签页部件。
    void Logout(); //!<做退出处理。
    void CreateDbTable(); //!<创建数据库表。
    void WriteCfg(); //!<输出配置信息。
    WLineEdit * DbPswdLineEdit; //!<在初始配置对话框中让用户输入数据库密码的输入框。
    WLineEdit * DbUsrNmLineEdit; //!<在初始配置对话框中让用户输入数据库用户名的输入框。
    WLineEdit * DbNmLineEdit; //!<在初始配置对话框中让用户输入数据库名字的输入框。
    void InitConfig(); //!<进行初始化配置。
    void PromptInitConfigure(); //!<弹出初始配置对话框。用来让用户输入初始化配置信息。
    void     DoLogin(); //!<处理登陆事项。
    bool LoggedIn; //!<用户是否已经登陆。
}; //class GenieProWeb : public WTabWidget

#endif // GENIEPROWEB_H
