#include <Wt/WApplication> //WApplication
#include <QCoreApplication> //QCoreApplication
#include <Wt/WServer> //WServer

#include "QueueMateWebApplication.h"  //QueueMateWebApplication

//全局变量：
QDate Version=QDate(2012,4,20); //版本号。
QueueMateWebApplication * GlobalApp; //全局的应用程序对象。
int ImgCtr; //图片计数器。

/*!
 * \brief createApplication 创建应用程序实例。
 * \param env 运行时的环境信息集合。
 * \return 所创建的实例。
 */
WApplication *createApplication(const WEnvironment& env)
{
    WApplication *app = new QueueMateWebApplication(env); //应用程序。
    GlobalApp=(QueueMateWebApplication*)(app); //记录全局应用程序。
    app->setTitle(WString::tr("StupidBeauty")); //设置窗口标题。
    app->enableUpdates(); //允许从其它线程更新界面。

    return app;
} //WApplication *createApplication(const WEnvironment& env)

/*!
  *@brief 主函数。
  */
int main(int argc, char *argv[])
{
    QCoreApplication App4QtEventLoop(argc,argv); //创建ＱＴ程序对象。

    //    return WRun(argc, argv, &createApplication);

    try {
        WServer server(argv[0]);

        server.setServerConfiguration(argc, argv, WTHTTP_CONFIGURATION);

        //      BlogSession::configureAuth();

        //      BlogRSSFeed rssFeed(server.appRoot() + "blog.db", "Wt blog example", "", "It's just an example.");

        if (server.start()) //启动服务器。
        {
            WServer::waitForShutdown();
            server.stop();
        } //if (server.start()) //启动服务器。
    }
    catch (WServer::Exception& e) //捕获服务器异常。
    {
        std::cerr << e.what() << std::endl;
    } //catch (WServer::Exception& e) //捕获服务器异常。
    catch (std::exception &e)  //捕获一般异常。
    {
        std::cerr << "exception: " << e.what() << std::endl;
    } //catch (std::exception &e)  //捕获一般异常。
} //int main(int argc, char *argv[])
