#ifndef SB_DB_CATEGORY_H
#define SB_DB_CATEGORY_H

#include "SbDbAccsPreCompile.h" //collection

#include "SbDbItem.h" //SbDbItem

class SbDbItem; //!<SbDbItem的前向声明。

/*!
 * \brief The AdInfo class Ad info.
 */
class SbDbCategory
{
public:
    WString description; //!<描述。
    dbo::ptr<SbDbCategory> categoryParent; //!<亲代分类对象。
    WString niceName; //!<漂亮名字。
    WString showName; //!<显示出来给用户看的名字。
    WString HowToUse; //!<How to use. XHTML.
    WString UpdateContent; //!<The content of the update text.
    WString ContactPhone; //!<The contact phone number.
    dbo::collection<dbo::ptr<SbDbItem> > itemList; //!<此分类下的文章列表。

    template <class Action>
    void persist(Action& a)
    {
        dbo::field(a,HowToUse,"howtouse"); //The how to use xhtml text.
        dbo::field(a,UpdateContent,"updatecontent"); //Update content.
        dbo::field(a,ContactPhone,"contactphone"); //The contact phone number.
        dbo::hasMany(a,itemList,dbo::ManyToMany,"item_category"); //文章与分类之间的关系。
    } //void persist(Action& a)


}; //class User


#endif // USER_H
