#ifndef SB_DB_COMMENT_H
#define SB_DB_COMMENT_H

#include <Wt/WString> //WString
#include <Wt/Dbo/Field> //field
#include <Wt/Dbo/collection> //collection

using namespace Wt; //WString
namespace dbo=Wt::Dbo; //dbo

#include "SbDbAuthor.h" //SbDbAuthor
#include "SbDbItem.h" //SbDbItem

class SbDbItem; //!<SbDbItem的前向声明。
class SbDbAuthor; //!<SbDbAuthor的前向声明。

/*!
 * \brief The SbDbComment class 数据库中的评论条目。
 */
class SbDbComment
{
public:
    WString commentAuthorEmail; //!<作者的邮箱。
    dbo::ptr<SbDbComment> commentParent; //!<此评论的亲代评论，即为，被此评论所引用的评论。
    WDateTime commentDateGmt; //!<GMT的评论时间。
    WString commentAuthorUrl; //!<评论作者的网址。
    dbo::ptr<SbDbAuthor> commentAuthor; //!<作者。
    WString commentDate; //!<评论的时间字符串。
    WString content; //!<评论的内容。
    WString commentAuthorIp; //!<评论的作者IP。
    WString commentAuthorName; //!< 评论的作者名字。
    dbo::ptr<SbDbItem> item; //!<此评论所关联到的文章。

    template <class Action>
    void persist(Action& a)
    {
        dbo::field(a,commentAuthorEmail,"commentauthoremail"); //作者的邮箱。
        dbo::belongsTo(a,item,"item_comment"); //文章。
    } //void persist(Action& a)
};

#endif // CONFIGINFO_H
