#ifndef SB_DB_AUTHOR_H
#define SB_DB_AUTHOR_H

#include "SbDbAccsPreCompile.h" //WString

#include "SbDbItem.h" //SbDbItem

/*!
 * \brief The ManagedUser class 被管理的用户。
 */
class SbDbAuthor
{
public:
    enum RoleEnum
    {
        Admin=1, //!<管理员。
        NormalUser=2, //!<普通用户。
        StoreManager=3 //!<The manager of a store.
    }; //enum RoleEnum

    WString ProxyLevelEnum2WString() const ;//!<将此用户的代理商级别以字符串形式返回.根据成员变量proxylevel的枚举值返回对应的可翻译字符串
    RoleEnum Role; //!<身份。
    WString name; //!<这名用户的名字。
    string password; //!<密码的MD5.
    WString email; //!<这名用户的邮箱。
    string loginname; //!<登录名。
    dbo::collection<dbo::ptr<SbDbItem> > itemList; //!<此作者的文章列表。

    template <class Action>
    void persist(Action& a)
    {
        dbo::field(a,name,"name"); //显示的名字。
        dbo::field(a,password,"password"); //密码的MD5。
        dbo::field(a,email,"email"); //邮箱。
        dbo::field(a,loginname,"loginname"); //登录用户名。
        dbo::field(a,Role,"role"); //角色。
        dbo::hasMany(a,itemList,dbo::ManyToOne,"item_author"); //文章列表。
    } //void persist(Action& a)
}; //class User


#endif // USER_H
