#ifndef SB_DB_ITEM_H
#define SB_DB_ITEM_H

#include "SbDbAccsPreCompile.h" //WDateTime

#include "SbDbTag.h" //SbDbTag
#include "SbDbCategory.h" //SbDbCategory
#include "SbDbAuthor.h" //SbDbAuthor
#include "SbDbComment.h" //SbDbComment

class SbDbComment; //!<SbDbComment的前向声明。
class SbDbCategory; //!<SbDbCategory的前向声明。
class SbDbTag; //!<SbDbTag的前向声明。
class SbDbAuthor; //!<SbDbAuthor的前向声明。

class SbDbItem
{
public:
    dbo::collection<dbo::ptr<SbDbTag> > tagList; //!<标记列表。
    dbo::collection<dbo::ptr<SbDbCategory> > categoryList; //!<分类列表。
    SbDbItem(); //!<Constructor.
    dbo::collection<dbo::ptr<SbDbComment> > commentList; //!<评论列表。
    WString title; //!<标题。
    WString content; //!<内容。
    WDateTime postDateGmt; //!<发布时间。GMT时区。
    dbo::ptr<SbDbAuthor> author; //!<作者。
    WString postDate; //!<以字符串表示的中文时区的发布时间。

    template <class Action>
    void persist(Action& a)
    {
        dbo::field(a,title,"title"); //标题。
        dbo::hasMany(a,tagList,dbo::ManyToMany,"item_tag"); //标记列表。
        dbo::hasMany(a,categoryList,dbo::ManyToMany,"item_category"); //评论列表。
        dbo::hasMany(a,commentList,dbo::ManyToOne,"item_comment"); //评论列表。
        dbo::belongsTo(a,author,dbo::ManyToOne,"item_author"); //作者。
    } //void persist(Action& a)
};

#endif // CONFIGINFO_H
