#ifndef SB_DB_TAG_H
#define SB_DB_TAG_H

#include "SbDbAccsPreCompile.h"

#include "SbDbItem.h" //SbDbItem

class SbDbItem; //!<SbDbItem的前向声明。

/*!
 * \brief The AdInfo class Ad info.
 */
class SbDbTag
{
public:
    WString niceName; //!<漂亮名字。也是唯一标识。
    WString showName; //!<显示出来的名字。
    dbo::collection<dbo::ptr<SbDbItem> > itemList; //!<此标记下的文章列表。

    template <class Action>
    void persist(Action& a)
    {
        dbo::field(a,niceName,"nicename"); //漂亮名字。
        dbo::hasMany(a,itemList,dbo::ManyToMany,"item_tag"); //文章列表。
    } //void persist(Action& a)
}; //class User

#endif // USER_H
