#include <Wt/Dbo/Dbo>
#include <Wt/Dbo/backend/MySQL>
#include <string>

namespace dbo = Wt::Dbo;


#include "sambhaashane_country_iso_3166_orm.h"

int main(int argc, char **argv)
{

    /*
      * Setup a session, would typically be done once at application startup.
      */
     dbo::backend::MySQL sambhaashane("sambhaashane",
                                      "sambhaashane",
                                      "secret",
                                      "localhost",
                                      3306,
                                      "/var/run/mysql/mysql.sock");
     sambhaashane.setProperty("show-queries", "true");
     dbo::Session session;
     session.setConnection(sambhaashane);
     session.mapClass<sambhaashane_country_iso_3166_orm>("country_iso_3166_tbl");
     dbo::Transaction transaction(session);
     {

         typedef dbo::collection< dbo::ptr<sambhaashane_country_iso_3166_orm> > Countries;
         Countries countries = session.find<sambhaashane_country_iso_3166_orm>();

         bool flag = transaction.isActive();

        // Countries countries = session.find<sambhaashane_country_iso_3166_orm>();
         dbo::collection< dbo::ptr<sambhaashane_country_iso_3166_orm> >::const_iterator country = countries.begin();
         int index = 0;
         while(country != countries.end())
         {
             std::cout << index++
                       << "] Country: "
                       << (*country)->country_iso_3166_numeric_code
                       << '\n';
             country++;
         }
     }
    //return WRun(argc, argv, &createApplication);
}


