#ifndef __SAMBHAASHANE_COUNTRY_ISO_3166_ORM_H__
#define __SAMBHAASHANE_COUNTRY_ISO_3166_ORM_H__

#include <Wt/Dbo/Dbo>
#include <string>

namespace dbo = Wt::Dbo;

class sambhaashane_country_iso_3166_orm;

namespace Wt
{
  namespace Dbo
  {
    template<>
    struct dbo_traits<sambhaashane_country_iso_3166_orm> : public dbo_default_traits
    {
        static const char autoincrementInsertSuffix()
        {
            return 0;
        }

        static const char *id()
        {
          return "country_iso_3166_numeric_code";
        }

        static const char *surrogateIdField()
        {
            return 0;
        }

        static const char *versionField()
        {
            return 0;
        }
    };
  }
}

class sambhaashane_country_iso_3166_orm
{
    public:
        int         country_iso_3166_numeric_code;
        std::string country_iso_3166_a2_code;
        std::string country_iso_3166_a3_code;
        std::string country_name;
        std::string country_legal_name;
        std::string country_native_name;
        int         currency_iso_4217_number_code;
        int         country_calling_code;
        std::string country_internet_extension;
        bool        country_follows_dst;

        template<class Action>
        void persist(Action& a)
        {
            dbo::id(a,country_iso_3166_numeric_code,        "country_iso_3166_numeric_code");
            dbo::field(a, country_iso_3166_a2_code,         "country_iso_3166_a2_code");
            dbo::field(a, country_iso_3166_a3_code,         "country_iso_3166_a3_code");
            dbo::field(a, country_name,                     "country_name");
            dbo::field(a, country_legal_name,               "country_legal_name");
            dbo::field(a, country_native_name,              "country_native_name");
            dbo::field(a, currency_iso_4217_number_code,    "currency_iso_4217_number_code");
            dbo::field(a, country_calling_code,             "country_calling_code");
            dbo::field(a, country_internet_extension,       "country_internet_extension");
            dbo::field(a, country_follows_dst,              "country_follows_dst");
        }
};

#endif // __SAMBHAASHANE_COUNTRY_ISO_3166_ORM_H__
